# README for VTA SMART Grant Data Package  
Strengthening Mobility and Revolutionizing Transportation (SMART) Program, U.S. Department of Transportation (USDOT)  
2025-08-08

## Links to Dataset  
Dataset Archive Link: <https://doi.org/10.21949/1404168>   

## Summary of Dataset  
This dataset supports the Santa Clara Valley Transportation Authority (VTA)’s SMART Grant-funded initiative to evaluate bike rack and wheelchair occupancy. This analysis uses Clever Devices vehicle state file data, Sportworks VeloLink feeds, and associated video evidence. As part of Stage 1, this data was used to identify routes, time periods, and stops with the highest frequency of ramp deployments and bicycles transported. These preliminary usage patterns will help VTA to provide better service for passengers bring wheels onboard.

The project aimed to reduce denied boardings due to lack of space, piloting a series of technologies to provide real-time occupancy data on ADA priority seating and bike rack.

## Tables of Contents  
##### A. General Information  
##### B. Sharing/Access & Policies Information  
##### C. Data and Related Files Overview  
##### D. Methodological Information  
##### E. Data-Specific Information  
##### F. Update Log

---

## A. General Information  

**Title of Dataset:**  VTA "Wheels on the Bus" SMART Grant - Bike Rack, Wheelchair Occupancy, and CCTV Videos Datasets

**Description of the Datasets:**
This dataset includes cumulative and timestamped sensor data, wheelchair ramp deployment logs, and visual evidence used to evaluate boarding events on VTA buses. It supports research on how to improve the customer experience for passengers bringing wheeled devices (e.g., bikes, wheelchairs, pushkarts, strollers, etc.) onto transit buses.

**Dataset Archive Link:** <https://doi.org/10.21949/1404168> 

**Authorship Information:**

> **Bike Rack Occupancy Datasets**  
> Name: Brian Stajkowski  
> Institution: Sportworks  
> Address: 13800 Fryelands Blvd, Ste 400, Monroe, WA 98272  
> Email: [brians@silverfallscapital.com](mailto:brians@silverfallscapital.com)  

> **Vehicle State File**  
> Name: Vincent Wong  
> Institution: Clever Devices  
> Address: 300 Crossways Park Drive, Woodbury, NY 11797  
> Email: [vwong@CleverDevices.com](mailto:vwong@CleverDevices.com)

> **Wheelchair Ramp Deployment Dataset**  
> Name: Rippal Kanda  
> Institution: Santa Clara Valley Transportation Authority (VTA)  
> Address: 3331 North First Street, Building B, San Jose, CA  95134  
> Email: [Rippal.Kanda@vta.org](mailto:Rippal.Kanda@vta.org)

> **Processed CCTV Videos (Computer Vision)**  
> Name: Jacob Niskey  
> Institution: AlwaysAI  
> Address: 160 Chesterfield Dr STE 102, Cardiff, CA  
> Email: [jacob.niskey@alwaysai.co](mailto:jacob.niskey@alwaysai.co)

**Date of data collection and update interval:** 

> Bike Rack Occupancy 'Historical' Dataset: October 2024 - April 2025  
> Bike Rack Occupancy 'Journeys' Dataset: February 2025 - April 2025  
> Vehicle State File: August 2024  
> Wheelchair Ramp Deployment Dataset: January 2023 to December 2024  
> Processed CCTV Footage: November 2024 – June 2025


**Geographic location of data collection:** Santa Clara County, CA [GeoNames URI: https://www.geonames.org/5393021/santa-clara-county.html](https://www.geonames.org/5393021/santa-clara-county.html)  

**Funding sources:** U.S. Department of Transportation, SMART Grant Program. Grant Number: 69A3552341049  

---

## B. Sharing/Access and Policies Information  

**Recommended citation for the data:**  
VTA (2025). "VTA "Wheels on the Bus" SMART Grant - Bike Rack, Wheelchair Occupancy, and CCTV Videos Datasets." Strengthening Mobility and Revolutionizing Transportation (SMART) Program. <https://doi.org/10.21949/1404181>

**Licenses/restrictions placed on the data:** The "VTA "Wheels on the Bus" SMART Grant project is distributed under the Creative Commons Attribution 4.0 License < https://creativecommons.org/licenses/by/4.0/>. This dataset may contain anonymized operational data. Video data is redacted or included only with VTA's consent.  

**Was data derived from another source?:** Yes (Sportworks VeloLink, VTA, Clever Devices, alwaysAI)  

---

## C. Data and Related Files Overview  

File List for the VTA_SMART_ACCESSIBILITY_DATASET.zip:

1. `sportworks_historical_api_3402_4403_buses.csv` – Number of bike rack slots and priority seats in use on a given bus, route, stop, and lat/lon. Each record represents the state of a bus.
2. `sportworks_journeys_api_3402.csv` - Pair of origin and destination lat/lons, along with associated vehicle, timestamp, route, and stop information. Each record represents a given trip for a bicyclist or passenger in a wheelchair.
3. `sportworks_data_dictionary.pdf` – Documentation of Sportworks VeloLink data elements, including a link to official documentation developed directly by Sportworks.
4. `clever_devices_vehicle_state_file.csv` – bike rack and wheelchair occupancy status data from Clever Devices, associated with "bus in a box" testing. Sportworks sensors are feeding into this data. The vehicle state file associated with the bus run in revenue service is not included here. Clever experienced a software configuration issue that prevented this occupancy data from flowing into the state file.
5. `wheelchair_ramp_deployments.csv` – Cleaned dataset of wheelchair ramp deployment records showing trip and temporal characteristics. Operator IDs appear in place of operator names. Deployments serve as a proxy dataset for ADA seating occupancy.
6. `alwaysAI_bus_priority_seat_monitoring.mov` - Processed CCTV footage using machine learning to identify occupancy_status of priority seats. Future analysis will capture what type of entity occupies this seat, ultimately intended for passenger-facing applications.
7. `README.md` – This documentation file
8. `DCAT-US_Metadata.json` – Required metadata file
9. `Data_Management_Plan.pdf` - Project data management plan.  

---

## D. Methodological Information  

**Description of methods used for data collection:**
- Sensor data from bike rack and wheelchair priority seats processed by Sportworks' Velolink
- Data pulled from Clever Devices' Intelligent Vehicle Network (IVN) logs and sensor streams
- Ramp deployment data collected by Clever Devices through motion of ramp
- CCTV footage processed using alwaysAI's computer vision model

**Software required:**
- Any text editor or Microsoft Excel (for CSV)
- Any video playback software such as Windows Media Player, VLC Media Player, etc. (for processed CCTV footage)

---

## E. Data-Specific Information  


1. `velolink_historical_api_3402_4403_buses.csv`
- Columns: 26
- Rows: 8,319
- Each row: bike rack status by timestamp
- Dictionary: see velolink_data_dictionary.pdf

2A. `velolink_journeys_api_3402.csv`  
- Columns: 33
- Rows: 76
- Each row: trip taken by a a bicyclist or passenger in wheelchair
- Dictionary: see velolink_data_dictionary.pdf

2B. `velolink_data_dictionary.pdf`  
N/A - Dictionary

3. `wheelchair_ramp_deployments.xls`
- Columns: 16
- Rows: 602834
- Each row: The state of bike rack and priority seat at a given time.
- Dictionary: Key fields are described below

4. `alwaysAI_bus_priority_seat_monitoring.mov`
- Footage from onboard bus cameras
- Duration: 2min 30s
- Frame rate: 7.99 frames/sec

5. `clever_devices_vehicle_state_file.csv` 
- Columns: 142
- Rows: 5
- Each row: The state of bike rack and priority seat at a given time.
- Dictionary: Key fields are described below

This file is a preliminary test on Clever Devices' ability to ingest sensor data.

The BiB was configured to have 3 inputs--labeled here as 1, 3, and 4--to track bike rack occupancy. They were virtually assigned to a bus in service, while the project team manipulated the sensors in the VTA Guadalupe Lab. the results can be seen in the spreadsheet in columns BM and BN. BM shows the current occupancy status, and BN shows the change from the last report. For example, the first test shows (2,2) as starting from zero, two bikes were added for a net change of +2 and a current status of 2. The second test shows (1,-1) as two bikes were removed and one was added for a net change of -1, and a current status of 1. 

However, this bus in the box test was not configured properly, causing inaccurate time stamps. The data represents just a select subset of snapshots into vehicle state.

TEST 1
union stop
activate 3 and 4 @12:04

TEST 2
bascom
remove 3 and 4 
activate 1 @12:06

TEST 3
winchester
activate 1,3,4 @12:09

TEST 4
hamilton
remove 1,3,4 @12:11


---

## F. Update Log
2025-08-08: File finalized by Tanay Gupta, WSP (ORCID: [0009-0001-7763-9000)](https://orcid.org/0009-0001-7763-9000)  
2025-07-29: Original file created by Michelle Bisceglia, WSP (ORCID: [0009-0004-4536-8199)](https://orcid.org/0009-0004-4536-8199)

---